VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Sliding Puzzle"
   ClientHeight    =   6885
   ClientLeft      =   60
   ClientTop       =   465
   ClientWidth     =   7890
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   24
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   ScaleHeight     =   6885
   ScaleWidth      =   7890
   StartUpPosition =   3  'Windows Default
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   250
      Left            =   6720
      Top             =   2760
   End
   Begin VB.CommandButton Shuffle_Button 
      Caption         =   "&Shuffle"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   6720
      TabIndex        =   4
      Top             =   1080
      Width           =   975
   End
   Begin VB.CommandButton Quit_Button 
      Caption         =   "&Quit"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   6720
      TabIndex        =   3
      Top             =   1920
      Width           =   975
   End
   Begin VB.CommandButton Run_Button 
      Caption         =   "Run"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   6720
      TabIndex        =   2
      Top             =   240
      Width           =   975
   End
   Begin VB.PictureBox Picture1 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   6400
      Left            =   120
      ScaleHeight     =   6345
      ScaleWidth      =   6345
      TabIndex        =   0
      Top             =   240
      Width           =   6400
      Begin VB.Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H8000000E&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   29.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   855
         Index           =   0
         Left            =   0
         TabIndex        =   1
         Top             =   0
         Width           =   855
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private Const n As Integer = 15
Private Const ShuffleCount As Integer = 75
Private EmptySquare As Integer

Private Sub Form_Load()
Dim i, shiftX, shiftY As Integer
Randomize
EmptySquare = 0
shiftX = Picture1.ScaleWidth / 4
shiftY = Picture1.ScaleHeight / 4
    
Label1(0).Width = shiftX
Label1(0).Height = shiftY
Label1(0).Move 0, 0
Label1(0).Caption = 0
Label1(0).Visible = False
    
For i = 1 To n
    Load Label1(i)
    Label1(i).Width = shiftX
    Label1(i).Height = shiftY
    Label1(i).Move shiftX * (i Mod 4), shiftY * Int(i / 4)
    Label1(i).Caption = i
    Label1(i).Visible = True
Next i
End Sub

Private Sub Label1_Click(Index As Integer)
Dim done As Boolean
done = False
If Index >= 0 And Index <= n Then
    If Not ((Index Mod 4) = 3) Then
        If Label1(Index + 1).Caption = "0" Then
            swap Index, Index + 1
            EmptySquare = Index
            done = True
        End If
    End If
    
    If Not ((Index Mod 4) = 0) And Not done Then
        If Label1(Index - 1).Caption = "0" Then
            swap Index, Index - 1
            EmptySquare = Index
            done = True
        End If
    End If

    If Not (Int(Index / 4) = 0) And Not done Then
        If Label1(Index - 4).Caption = "0" Then
            swap Index, Index - 4
            EmptySquare = Index
            done = True
        End If
    End If

    If Not ((Index / 4) = 3) And Not done Then
        If Label1(Index + 4).Caption = "0" Then
            swap Index, Index + 4
            EmptySquare = Index
            done = True
        End If
    End If
End If
End Sub

Private Sub Quit_Button_Click()
    Unload Me
End Sub

Public Sub swap(i As Integer, j As Integer)
    Dim temp As Integer
    temp = Label1(i).Caption
    Label1(i).Caption = Label1(j).Caption
    Label1(j).Caption = temp
    Label1(i).Visible = Label1(j).Visible
    Label1(j).Visible = Not (Label1(i).Visible)
End Sub

Private Sub Run_Button_Click()
    Timer1.Enabled = True
End Sub

Private Sub Shuffle_Button_Click()
Dim i As Integer
Dim random As Integer
    For i = 1 To ShuffleCount
        random = Rnd * 32767 Mod 4
        Random_Move random
    Next i
    
End Sub

Private Sub Random_Move(rand As Integer)
    If rand = 0 Then
        Label1_Click (EmptySquare + 1) 'Right
    Else
        If rand = 1 Then
          Label1_Click (EmptySquare - 1) 'Left
        Else
            If rand = 2 Then
                Label1_Click (EmptySquare + 4) 'Down
            Else: Label1_Click (EmptySquare - 4) 'Up
            End If
        End If
    End If
End Sub

Private Sub Timer1_Timer()
Dim random As Integer
    random = Rnd * 32767 Mod 4
    Random_Move random
End Sub
